/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.client.render.StashDetectorRenderer;
import dev.toma.gunsrpg.common.LootStashDetectorHandler;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.UUID;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.Animation;
import lib.toma.animations.api.IAnimationEntry;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StashDetectorItem
extends BaseItem
implements IAnimationEntry {
    public static final ResourceLocation CHARGE_BATTERY_ANIMATION = GunsRPG.makeResource("stash_detector/change_batteries");
    public static final ResourceLocation TURN_ON_ANIMATION = GunsRPG.makeResource("stash_detector/turn_on");
    public static final ResourceLocation TURN_OFF_ANIMATION = GunsRPG.makeResource("stash_detector/turn_off");

    public StashDetectorItem(String name) {
        super(name, new Item.Properties().func_200916_a(ModTabs.ITEM_TAB).func_200918_c(210).setISTER(() -> StashDetectorRenderer::new));
    }

    public static boolean isValidBatterySource(ItemStack stack) {
        return stack.func_77973_b() == ModItems.BATTERY;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        IPlayerData data = PlayerData.getUnsafe(player);
        ISkillProvider provider = data.getSkillProvider();
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (!provider.hasSkill(Skills.TREASURE_HUNTER_I)) {
            if (!level.field_72995_K) {
                ((ServerPlayerEntity)player).func_241151_a_(SkillUtil.getMissingSkillText(Skills.TREASURE_HUNTER_I), ChatType.GAME_INFO, Util.field_240973_b_);
            }
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (level.field_72995_K) {
            this.playUseAnimation(player.func_110124_au());
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public boolean disableVanillaAnimations() {
        return false;
    }

    @Override
    public IRenderConfig right() {
        return RenderConfigs.HEAL_CONFIG;
    }

    @Override
    public IRenderConfig left() {
        return RenderConfigs.HEAL_CONFIG;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playUseAnimation(UUID uuid) {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        ResourceLocation location = LootStashDetectorHandler.isUsing(uuid) ? TURN_OFF_ANIMATION : TURN_ON_ANIMATION;
        pipeline.insert(ModAnimations.STASH_DETECTOR, AnimationUtils.createAnimation(location, provider -> new Animation((IKeyframeProvider)provider, 35)));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xFFFF00;
    }

    public static enum StatusEvent {
        ON,
        OFF,
        TOGGLE;

    }
}

